//
//  DeleteCell.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 18.02.23.
//

import Foundation
import UIKit

class DeleteCell : UICollectionViewCell {
    
    

    
    override init(frame: CGRect) {
        super.init(frame: frame)

        let boldConfig = UIImage.SymbolConfiguration(weight: .light)
        let imageConfirm = UIImage(systemName: "delete.left", withConfiguration: boldConfig)?.withRenderingMode(.alwaysTemplate) //
        
        // cell's background color
        backgroundColor = UIColor.clear
        
        
        let imageView = UIImageView(image: imageConfirm)
        imageView.tintColor = UIColor.white
        
        imageView.contentMode = .scaleAspectFit
        addSubview(imageView)
        imageView.centerInSuperview(size: .init(width: 40, height: 40))
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        layer.cornerRadius = frame.width / 2
    }
    
    required init?(coder aDecoder:NSCoder) {
        fatalError()
    }
    
}
